/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.item;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemGroup;
import technology.rocketjump.undermount.entities.model.physical.item.ItemHoldPosition;
import technology.rocketjump.undermount.jobs.model.CraftingType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ItemType {
    private long itemTypeId;
    private String itemTypeName;
    private ItemGroup itemGroup;
    private int maxStackSize = 1;
    private int maxHauledAtOnce;
    private List<GameMaterialType> materialTypes = new ArrayList<GameMaterialType>();
    private GameMaterialType primaryMaterialType;
    private ItemHoldPosition holdPosition = ItemHoldPosition.IN_FRONT;
    private boolean impedesMovement;
    private boolean blocksMovement;
    private List<String> relatedCraftingTypeNames = new ArrayList<String>();
    @JsonIgnore
    private List<CraftingType> relatedCraftingTypes = new ArrayList<CraftingType>();

    public long getItemTypeId() {
        return this.itemTypeId;
    }

    public void setItemTypeId(long itemTypeId) {
        this.itemTypeId = itemTypeId;
    }

    public String getItemTypeName() {
        return this.itemTypeName;
    }

    public void setItemTypeName(String itemTypeName) {
        this.itemTypeName = itemTypeName;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public int getMaxHauledAtOnce() {
        return this.maxHauledAtOnce;
    }

    public void setMaxHauledAtOnce(int maxHauledAtOnce) {
        this.maxHauledAtOnce = maxHauledAtOnce;
    }

    public boolean impedesMovement() {
        return this.impedesMovement;
    }

    public void setImpedesMovement(boolean impedesMovement) {
        this.impedesMovement = impedesMovement;
    }

    public boolean blocksMovement() {
        return this.blocksMovement;
    }

    public void setBlocksMovement(boolean blocksMovement) {
        this.blocksMovement = blocksMovement;
    }

    public ItemHoldPosition getHoldPosition() {
        return this.holdPosition;
    }

    public void setHoldPosition(ItemHoldPosition holdPosition) {
        this.holdPosition = holdPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemType itemType = (ItemType)o;
        return this.itemTypeId == itemType.itemTypeId;
    }

    public int hashCode() {
        return Objects.hash(this.itemTypeId);
    }

    public String toString() {
        return this.itemTypeName;
    }

    public List<GameMaterialType> getMaterialTypes() {
        return this.materialTypes;
    }

    public void setMaterialTypes(List<GameMaterialType> materialTypes) {
        this.materialTypes = materialTypes;
    }

    public GameMaterialType getPrimaryMaterialType() {
        return this.primaryMaterialType;
    }

    public void setPrimaryMaterialType(GameMaterialType primaryMaterialType) {
        this.primaryMaterialType = primaryMaterialType;
    }

    public ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    public void setItemGroup(ItemGroup itemGroup) {
        this.itemGroup = itemGroup;
    }

    public boolean isImpedesMovement() {
        return this.impedesMovement;
    }

    public boolean isBlocksMovement() {
        return this.blocksMovement;
    }

    public List<String> getRelatedCraftingTypeNames() {
        return this.relatedCraftingTypeNames;
    }

    public void setRelatedCraftingTypeNames(List<String> relatedCraftingTypeNames) {
        this.relatedCraftingTypeNames = relatedCraftingTypeNames;
    }

    public List<CraftingType> getRelatedCraftingTypes() {
        return this.relatedCraftingTypes;
    }

    public void setRelatedCraftingTypes(List<CraftingType> relatedCraftingTypes) {
        this.relatedCraftingTypes = relatedCraftingTypes;
    }

    public String getI18nKey() {
        return this.itemTypeName.toUpperCase().replaceAll("-", ".").replaceAll(" ", "_");
    }
}

